filein "CATMacroUtilFunctions.ms"

global rPoseMixer;

if (classof rPoseMixer) == RolloutClass do destroyDialog rPoseMixer

rollout rLMR "" width:304 height:40
(
	radioButtons rdoLMR "" pos:[24,11] width:171 height:16 labels:#(~LEFT~, ~MIDDLE~, ~RIGHT~) columns:3 default:2
	button btnOK ~BTNOK_CAPTION~ pos:[224,8] width:72 height:24;
	
	fn OpenDialog =
	(
		
		createDialog rLMR pos:(GetDialogPos rPoseMixer) style:#(#style_border, #style_titlebar, #style_sysmenu, #style_resizing)  modal:true
		return (rdoLMR.state-2);
	)
	on btnOk pressed  do
	(
		try(destroyDialog rLMR )catch();
	)
)


rollout rPoseMixer ~RPOSEMIXER_CAPTION~ width:240 height:300
(
	local ini_file = ((getDir #plugcfg_ln) + "\\CAT\\PoseMixer.ini");
	local posespath = ((getDir #plugcfg_ln) + "\\CAT\\PoseMixer\\*.pmf"); 
	local posefiles, posefolders;
	struct posevalue ( ctrl="", value=(matrix3 1) );
	struct posestruct ( lmr=0, values=#() );
	local pose = undefined;
	local catparent = undefined;
	local spinningLeft = false;
	local spinningRight = false;
	local mirrorPose = false;
	local relativeLoad = false;
	
	fn CATRigFilter o = ((GetCATParent o)!=undefined)
	

--	button btnSetPresetLocation ~POSES_FOLDER~ pos:[120,8] width:80 height:25
--	pickbutton btnPickCATRig "CATRig:" pos:[204,8] width:80 height:25 filter:CATRigFilter
	
	button btnSetPresetLocation ~BTNSETPRESETLOCATION_POSES_FOLDER~ pos:[5,5] width:110 height:25
	pickbutton btnPickCATRig "CATRig:" pos:[121,5] width:110 height:25 filter:CATRigFilter
	
	listbox lbxPoses 	"" 			pos:[5,33] 		width:400 height:15
	button btnSavePose 	~BTNSAVEPOSE_CAPTION~ 		pos:[5,256] 	width:~BTNSAVEPOSE_WIDTH~  height:25
	spinner spnLeft 	~SPNLEFT_CAPTION~ 	pos:~SPNLEFT_POSITION~ 	width:~SPNLEFT_WIDTH~ height:16 scale:1	range:[-200,200,0]
	spinner spnRight 	~SPNRIGHT_CAPTION~ 	pos:[312,256] 	width:~SPNRIGHT_WIDTH~ height:16 scale:1	range:[-200,200,0]
	
	fn ArrageUIElements =
	(
		local size = GetDialogSize rPoseMixer;	
		if catparent == undefined and size.x < 260 then rPoseMixer.width = size.x = 260;
		if size.x < 190 then rPoseMixer.width = size.x = 190;
		if size.y < 130 then rPoseMixer.height = size.y = 130
		
		lbxPoses.width 	= size.x - 13
		lbxPoses.height = size.y - 65
		btnSavePose.pos = [10, size.y - 28];
		btnSavePose.visible = (size.x > 240);
		spnLeft.pos 	= [size.x - 130, size.y - 23]
		spnRight.pos 	= [size.x - 25, size.y - 23]
	)
	
	fn FillListBox =
	(	
		local posefilenames = #("<..>");
		posefolders = getDirectories (posespath + "*");
		for folder in posefolders do(
			append posefilenames ("<" + (substring folder (posespath.count + 1) -1) + ">")
		)
		
		posefiles = getFiles (posespath + "*.pmf")
		for file in posefiles do(
			append posefilenames (getFilenameFile file)
		)
		lbxPoses.items = posefilenames;
		lbxPoses.selection = 1;
		pose = undefined;
	)
	fn Refresh =
	(
		if catparent!=undefined then
			btnPickCATRig.text = ("CATRig:" + catparent.catname)
			
		lbxPoses.enabled = (catparent!=undefined);
		btnSavePose.enabled = (catparent!=undefined);
		spnLeft.enabled = (catparent!=undefined) and (pose!=undefined);
		spnRight.enabled = (catparent!=undefined) and (pose!=undefined);
	)
	
	fn GetSelectedCATBones = 
	(
		local catbones = #();
		for o in $selection do
		(
			if(GetCATParent o)!=undefined and (((classof o.baseobject) as string)!="CATParent") then
			(
				append catbones o
			)
		)
		return catbones;
	)
	
	fn GetSelectedCATParent = 
	(
		for o in $selection do(	if(GetCATParent o)!=undefined then return (GetCATParent o))
		return undefined;
	)
	
	fn SavePoseMixerFile filepath lmr:0 = 
	(
		local file = createFile filepath;
		local layerctrls = catparent.CATRigLayerCtrls;
		format "LMR=%\n" lmr to:file;
		for ctrl in layerctrls do
		(
			try(
			if (classof ctrl)==LayerMatrix3 then ( -- and (superclassof ctrl.catcontrol)==Matrix3Controller then (
				if ctrl.catcontrol.node.isselected then (
					local setupval = ctrl.setupval;
				--	setupval.pos = setupval.pos * ctrl.CATControl.catparent.catunits
					format "%=%\n" ctrl.catcontrol.address (ctrl.value * (Inverse setupval)) to:file;
				)
			)
			)catch()
		)
		close file;	
	)
	
	fn LoadPoseMixerFile filepath = 
	(	
		if catparent==undefined or not (doesFileExist filepath) then return OK;
		
		local file = openFile filepath;
		pose = posestruct();
		seek file 0
		while not eof file do
		(
			local line = readLine file;
			local data = filterString line "="
			if(data.count!=2) then continue;
			case data[1] of(
				"LMR": pose.lmr = (data[2] as number)
				default:(
					try(
						local cbone = catparent.GetBoneByAddress data[1];
						local newposevalue = (posevalue ctrl:(cbone[3].layertrans) value:(execute data[2]) );
						append pose.values newposevalue
					)catch()
				)
			)
			
		)
		close file;	
	/*	-- refs.dependencyLoopTest $RigFaceLMouth[3][1].controller pose.values[i-1].ctrl
		local i = 2;
		while i < pose.values.count do(
			local j = 1;
			print i;
		--	while j > 0 do(
			for j = (i-1) to 1 by -1 do(
				print j;
				print pose.values[i].ctrl.catcontrol.node.name;
				print pose.values[j].ctrl.catcontrol.node.name;
				if (refs.dependencyLoopTest pose.values[i].ctrl pose.values[j].ctrl) then(
					print "-----"
					print i
				)
			--	if (refs.dependencyLoopTest pose.values[j].ctrl pose.values[i].ctrl) then(
			--		print "+++++"
			--		print i
			--	)
			)	
		--	)
			i = i + 1;
		)
	*/
	)
	
	fn OpenDialog =
	(
		try(destroyDialog rPoseMixer)catch();
		local pos = execute (getIniSetting ini_file #general #position)
		if pos == ok then pos = [100, 100]
		local dim = execute (getIniSetting ini_file #general #dimensions)
		if dim == ok then dim = [905 , 355]
		
		createDialog rPoseMixer pos:pos width:dim.x height:dim.y style:#(#style_border, #style_titlebar, #style_sysmenu, #style_resizing)  lockHeight:false lockWidth:false --bgcolor:(color 0 125 0)
	
		posespath = getIniSetting ini_file ~FILES_CAPTION~ "CATPoseMixerFilesPath"
		if(posespath.count == 0) then posespath = ((getDir #plugcfg_ln) + "\\CAT\\")
	
		ArrageUIElements();
		try( catparent = (GetCATParent selection[1]) )catch();
		FillListBox();
		Refresh()
	)
	
	on btnSavePose pressed do
	(
		local catbones = GetSelectedCATBones();
		if catbones.count == 0 then(
			MessageBox ~MSGBOX_PLEASE_SELECT_SOME_BONES~
			return OK;
		)
		if catbones[1][3].catparent.catmode==0 then(
			MessageBox ~PUT_CATRIG_IN_ANIMATE_MODE~
			return OK;
		)
	--	local lastfileloaded = getIniSetting ini_file ~LASTFILELOADED_FILES_CAPTION~ "CATPoseMixerFilePath"
	--	if(lastfileloaded.count == 0)then lastfileloaded = ((getDir #plugcfg_ln) + "\\CAT\\*.pmf")
		local poseMixerFile = (posespath + "PoseMixerFile.pmf")
		local f = getSaveFileName caption:~GETSAVEFILENAME_CAPTION~ types:~GETSAVEFILENAME_FILE_TYPES~ filename:poseMixerFile 
		if f != undefined then
		(
			setIniSetting ini_file ~INI_FILE_FILES~ "CATPoseMixerFilePath" f
			SavePoseMixerFile f lmr:(rLMR.OpenDialog());
			posespath = getFilenamePath f;
			FillListBox();
			Refresh();
		)
	)
	
	-----------------------------------------------------------------
	-- Calbacks
	fn BlendValue v1 v2 weight =
	(	
		if weight == 1.0 then return v2;
		local blendedpositionvalue = v1.translation + ((v2.translation - v1.translation) * weight);
	--	local blendedscalevalue = v1.scalepart + ((v2.scalepart - v1.scalepart) * weight);
		local blendedscalevalue = [1,1,1] + ((v2.scalepart -  [1,1,1] ) * weight);

		local qBlend, qOffset = (v2 * (Inverse v1)) as quat;
		-- I did this because the normal slerp was taking the long way round the sphere
		if qOffset.angle > 180 then qOffset.axis = qOffset.axis * [-1.0, -1.0, -1.0] ;
		Normalize qOffset;
		if weight<0.0 then(
			qOffset = (Inverse qOffset);
			qBlend = (slerp (quat 0.0 [0,0,1]) qOffset -(weight - (ceil weight)));
			-- The weight value can exceed 1.0, so we add the offset on mutiple times if it is
			for i = 1 to -(ceil weight) do qBlend = qBlend * qOffset;
		)else(
			qBlend = (slerp (quat 0.0 [0,0,1]) qOffset (weight - (floor weight)));
			-- The weight value can exceed 1.0, so we add the offset on mutiple times if it is
			for i = 1 to (floor weight) do qBlend = qBlend * qOffset;
		)
		
		v1 = (qBlend as Matrix3) * v1;
		v1.translation = blendedpositionvalue;
		preScale v1 blendedscalevalue;
		v1;
	)
	fn MirrorVal &v =
	(
		if catparent.lengthaxis == "X" then
		(
			v[1] *= [ 1, 1,-1]; 
			v[2] *= [ 1, 1,-1]; 
			v[3] *= [-1,-1, 1]; 
			v[4] *= [ 1, 1,-1]; 
		)else(
			v[1] *= [ 1,-1,-1]; 
			v[2] *= [-1, 1, 1]; 
			v[3] *= [-1, 1, 1]; 
			v[4] *= [-1, 1, 1]; 
		)
	)
	
	fn SetPose weight = 
	(
		if catparent.catmode==0 then(
			MessageBox ~MSGBOX_PUT_CATRIG_IN_ANIMATE_MODE~
			return OK;
		)
		with redraw off
		(
			for p in pose.values do
			(
				local ctrl;
				local val = copy p.value;
			--	if mirrorPose and p.ctrl.catcontrol.mirrorbone != undefined then (
				if mirrorPose then (
					if p.ctrl.catcontrol.mirrorbone != undefined then
						 ctrl = p.ctrl.catcontrol.mirrorbone[3].layertrans;
					else ctrl = p.ctrl;
					MirrorVal &val;
				)else ctrl = p.ctrl;
	
				if relativeLoad then (
					 local temp = val * ctrl.setupval;
					 val = val * ctrl.value;
					 val.pos = ctrl.value.pos + (temp.pos - ctrl.setupval.pos)
				)	else	(
				--	local setupval = ctrl.setupval;
				--	setupval.pos = setupval.pos * catparent.catunits;
					val = val * ctrl.setupval;
				)
				ctrl.value = (BlendValue ctrl.value val weight);
			)
		)
	)
	
	on rPoseMixer close do
	(	
		if toolMode.CommandMode == #pick do toolMode.CommandMode = #move
		callbacks.removeScripts id:#rPoseMixer;
		setIniSetting ini_file #general #position 	((getDialogpos rPoseMixer) as string)
		setIniSetting ini_file #general #dimensions ((GetDialogSize rPoseMixer) as string)
		setIniSetting ini_file ~SETINI_FILE_FILES~ "CATPoseMixerFilesPath" posespath
	)
	
	on rPoseMixer resized size do
	(
		ArrageUIElements() 
	)
	
	on btnSetPresetLocation pressed do
	(
		f = getSavePath caption:~GETSAVEPATH_CAPTION~ initialDir:posespath
		if f != undefined then
		(
			posespath = f;
			if posespath[posespath.count]!='\' then posespath = (posespath + "\\");
			setIniSetting ini_file ~SETINI_FILE_FILES_CAPTION~ "CATPoseMixerFilesPath" posespath
			FillListBox();
			Refresh();
		)
	)
	
	on btnPickCATRig picked obj do
	(
		catparent = GetCATParent obj;
		Refresh();
	)
	
	on lbxPoses selected sel do
	(
		if sel > (posefolders.count+1) then (
			LoadPoseMixerFile posefiles[sel - (posefolders.count+1)]
		)
		Refresh();
	)
	
	on lbxPoses doubleClicked sel do
	(	
		if(sel==1)then(
			posespath = getFilenamePath (substring posespath 1 (posespath.count-2))
		)else if sel <= (posefolders.count+1) then(
			posespath = posefolders[sel-1];
		)else(
			relativeLoad = false;
			undo ~UNDO_POSE_SET~ on(	SetPose 1.0	)
			return OK;
		)
		pose = undefined;
		setIniSetting ini_file "Files" "CATPoseMixerFilesPath" posespath
		FillListBox();
		Refresh();
	)	

	on spnLeft changed val do(	
		if not spinningLeft then(
			if pose == undefined then return OK;
			try(
				theHold.Begin();
				spinningLeft = true;
				if pose.lmr == 1 then mirrorPose = true;
				else				  mirrorPose = false;
				relativeLoad = not keyboard.altPressed;
				-- I have decided to lock in realtive loading all the time.
			--	relativeLoad = true;
			)catch ( theHold.Cancel();	)
		)else(
			theHold.Restore()
		)
		try(	SetPose (val/100.0);	)
		catch(	theHold.Cancel();		)
	)
	
	on spnLeft entered do
	(
		if not spinningLeft then 
		(
		--	print "undo Pose Set on"
		)else(
		--	if spnLeft.value==0.0 then theHold.Cancel();
		--	else (
				theHold.Accept ~POSE_SET_LEFT~
				spinningLeft = false;
		--	)
		)
		spnLeft.value = 0;
	)
	on spnRight changed val do(	
		if not spinningRight then(
			if pose == undefined then return OK;
			try(
				theHold.Begin();
				spinningRight = true;
				if pose.lmr == -1 then mirrorPose = true;
				else				   mirrorPose = false;
				-- I have decided to lock in realtive loading all the time.
				relativeLoad = not keyboard.altPressed;
			--	relativeLoad = true;
			) catch ( theHold.Cancel();	)
		)else(
			theHold.Restore()
		)
		try(	SetPose (val/100.0);	)
		catch(	theHold.Cancel();		)
	)
	
	on spnRight entered do
	(
		if not spinningRight then 
		(
		--	print "undo Pose Set on"
		)else(
		--	if spnRight.value==0.0 then theHold.Cancel();
		--	else (
				theHold.Accept ~POSE_SET_RIGHT~
				spinningRight = false;
		--	)
		)
		spnRight.value = 0;
	)
	
)



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBUbpdUww2T7h/IGaoUrcJlgwRTLDTMJXKJ
-- lj6zaTQafSrst0DlDbFjxTDgEnUolkUjKvzZu94efo88E0C11kw1yuRdYq/PISn/
-- PCJgkp+TBuMveEBGyfBqdBZgpz79VJ8QhnQ0KWC0go1EgV4bTQ6Cwhq7Mm1+0Zw9
-- r623MQdPrRgH4p0SxYli6/NF1AfzUX7EVpULRCCrmPTCdbaPwdOHHl3yNFrc9qfI
-- 190Rh2CJd+PMrvickxyDbWSxUR8kewpPyieQu6BTj+cv7LgHSLd/p+xh/ZTojOF3
-- cBEmaaq+7vJI5vtatCIDee1adbjBqtahfM2pfE1QARW6Oryg4E6K
-- -----END-SIGNATURE-----